(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35168,       1058]*)
(*NotebookOutlinePosition[     36511,       1096]*)
(*  CellTagsIndexPosition[     36467,       1092]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["N\[UAcute]meros complejos. Resoluci\[OAcute]n de ecuaciones", "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que debes aprender en este cuaderno.
Usar los comandos b\[AAcute]sicos para trabajar con n\[UAcute]meros \
complejos.
Resolver ecuacioes usando los comandos Solve[ ], NSolve[ ], Reduce[ ] y \
FindRoot[ ].\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Aritm\[EAcute]tica. Forma polar. Ra\[IAcute]ces, logaritmos y potencias \
complejas.\
\>", "Section"],

Cell[TextData[{
  "Empezaremos aprendiendo algunos comandos espec\[IAcute]ficos que tiene ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con n\[UAcute]meros complejos. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la letra I may\[UAcute]scula representa la unidad imaginaria. No olvides \
dejar un espacio libre al escribirla. Tambi\[EAcute]n puedes escribir la \
unidad imaginaria tecleando \"\[EscapeKey] ii \[EscapeKey]\"."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[\(z = \(-5\) + I\ 4\),
        "Input"], 
      StyleBox[";",
        "Input"], "\n", 
      StyleBox[\(Re[z]\),
        "Input"]}], 
    StyleBox[\(Im[z]\),
      "Input"], 
    StyleBox[\(Abs[z]\),
      "Input"], \(Arg[z]\), \(Conjugate[z]\), 
    StyleBox[\(Clear[z]\),
      "Input"]}], "Input"],

Cell["\<\
Como ves \"Re[ ]\" e \"Im[ ]\" dan la parte real e imaginaria, \"Abs[ ]\" nos \
da el m\[OAcute]dulo, \"Arg[ ]\" es el argumento principal y \"Conjugate[ ]\" \
es el conjugado. \
\>", "Text",
  TextJustification->1],

Cell[TextData[{
  "Te recuerdo que ",
  StyleBox[
  "Mathematica  trabaja siempre con n\[UAcute]meros complejos por defecto",
    FontSlant->"Italic"],
  ", por eso cuando una expresi\[OAcute]n contenga variables no debes olvidar \
que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las tratar\[AAcute] como n\[UAcute]meros complejos.  Por ejemplo, no \
debes pensar que Re[a + i b] debe ser a, puesto que ello s\[OAcute]lo es as\
\[IAcute] cuando a y b son n\[UAcute]meros reales."
}], "Text"],

Cell[BoxData[{
    \(Re[a + I\ b]\), 
    \(Conjugate[a\  + \ I\ b]\), 
    \(Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]\)}], "Input"],

Cell[TextData[{
  "Podemos decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ciertas variables son reales con la orden",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["ComplexExpand[expr]\" ",
    FontFamily->"Times New Roman"],
  "que desarrolla ",
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["expr", "TI",
    FontFamily->"Times New Roman",
    FontSlant->"Plain"],
  StyleBox["\"", "TI",
    FontFamily->"Times New Roman",
    FontSize->9,
    FontSlant->"Plain"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSize->14],
  "suponiendo que todas las variables que figuran en la misma son reales."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[
        RowBox[{"C", 
          StyleBox["omplexExpand",
            "Input"]}]], 
      StyleBox["[",
        "Input"], 
      StyleBox[\(Re[a + I\ b]\),
        "Input"], 
      StyleBox["]",
        "Input"]}], 
  \(ComplexExpand[Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]]\), 
  \(ComplexExpand[Conjugate[a\  + \ I\ b]]\)}], "Input"],

Cell[TextData[
"Para que te convenzas de que Arg[z] es el argumento principal de z, observa \
en la siguiente gr\[AAcute]fica la disontinuidad del argumento en t=\[Pi] \
punto en el que salta de \[Pi] a -\[Pi]."], "Text"],

Cell[BoxData[
    \(\(Plot[Arg[Cos[t] + \ I\ Sin[t]], {t, 0, 2  \[Pi]}, 
      Ticks -> {\[Pi]/3\ Range[6], {\(-\[Pi]\), \[Pi]}}]; \)\)], "Input"],

Cell[TextData[{
  "No hay ninguna novedad en lo referente a la multiplicaci\[OAcute]n y a la \
divisi\[OAcute]n de n\[UAcute]meros complejos: se hacen de la forma usual. \
Tambi\[EAcute]n se hacen de la forma usual las potencias. Mererece la pena \
detenerse en las potencias de exponente racional y complejo para entender c\
\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con ellas. Vamos a considerar las ra\[IAcute]ces de un n\[UAcute]mero \
complejo. Ya sabes que todo n\[UAcute]mero complejo distinto de cero tiene n \
ra\[IAcute]ces n-\[EAcute]simas distintas. \[DownQuestion]Cu\[AAcute]l de \
ellas es la que se representa en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por z^(1/n) o, lo que es igual, por ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\%n\)]],
  "? Para saberlo podemos usar ComplexExpand."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[\((x\  + \ I\ y)\)^{1/3}]\)], "Input"],

Cell[TextData[{
  "Es decir, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona siempre el ",
  StyleBox["valor principal",
    FontSlant->"Italic"],
  " de la ra\[IAcute]z. Ahora puedes comprender por qu\[EAcute] si le pides a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\^3\)\%3\)]],
  "la respuesta no puede ser ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". F\[IAcute]jate que si ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es real entonces s\[IAcute] es cierto es que ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "es la \[UAcute]nica ra\[IAcute]z c\[UAcute]bica ",
  StyleBox["real",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3\)]],
  ", pero ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " por defecto, trata ",
  StyleBox["x",
    FontSlant->"Italic"],
  " como un n\[UAcute]mero complejo y hay ",
  StyleBox["tres",
    FontSlant->"Italic"],
  " complejos distintos que tienen igual cubo. Por eso la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\^3\)\%3 = z\)]],
  " no es cierta en general. Ya debes saber que dicha igualdad se verificar\
\[AAcute] solamente cuando -\[Pi]/3<Arg[z]\[LessEqual]\[Pi]/3. \
Tambi\[EAcute]n puedes entender por qu\[EAcute] si pides a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\(\@z\) \@w\)]],
  " la respuesta no puede ser ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\ w\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\@\(z\^3\)\%\(3\ \)\), 
    \(\(\@z\) \@w\)}], "Input"],

Cell[BoxData[
    \(\(ComplexExpand[\@\(I\^3\)\%3]\ \ \  (*
      en\ general\ no\ es\ cierto\ que\ \@\(z\^3\)\%3\ sea\ igual\ a\ z*) 
      \)\)], "Input"],

Cell[BoxData[
    RowBox[{\(ComplexExpand[\@\(-1\)\%3]\), " ", 
      RowBox[{"(*", 
        RowBox[{
        "los", " ", "n\[UAcute]meros", " ", "reales", " ", "negativos", " ", 
          "son", " ", "tratados", " ", "como", " ", "n\[UAcute]meros", " ", 
          \(complejos . \ Ya\), " ", "ves", " ", "que", " ", "Mathematica", 
          " ", "proporciona", " ", 
          StyleBox["siempre",
            FontSlant->"Italic"], " ", "el", " ", "valor", " ", "principal", 
          " ", "de", " ", "la", " ", "ra\[IAcute]z"}], "*)"}]}]], "Input"],

Cell[BoxData[{
    \(\(\@\(-I\)\) \@\(-I\)\ \ \ \ \ \ \ \  (*
      en\ general\ no\ es\ cierto\ que\ \(\@z\) \@w\ sea\ igual\ a\ 
        \@\(z*w\)*) \), 
    \(\@\(\((\(-I\))\)*\((\(-I\))\)\)\)}], "Input"],

Cell[TextData[{
  "Ya ves que saber un poquito de n\[UAcute]meros complejos ayuda a entender \
lo que hace ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " "
}], "Text"],

Cell[TextData[{
  "Veamos c\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con los logaritmos complejos."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[x\  + \ I\ y]]\)], "Input"],

Cell[TextData[{
  "Es decir, la funci\[OAcute]n Log[z] nos da el ",
  StyleBox["valor principal ",
    FontSlant->"Italic"],
  "del logaritmo de z. Ahora puedes entender la siguiente respuesta de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \(Exp[Log[z]]\), 
    \(Log[Exp[z]]\ \  (*
      en\ general\ no\ es\ verdad\ que\ Log[Exp[z]]\ sea\ igual\ a\ z*) \), 
    \(Log[Exp[7\ I]]\  (*aqu\[IAcute]\ tienes\ un\ ejemplo*) \)}], "Input"],

Cell["Veamos lo que vale Log[Exp[z]].", "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[Exp[x\  + \ I\ y]]]\)], "Input"],

Cell[BoxData[{
    \(ComplexExpand[Log[\(-1\) + I\ \@3] + Log[\(-\@3\) + I]]\  (*
      en\ general\ no\ es\ verdad\ que\ Log[z]\  + \ 
        Log[w]\ sea\ igua\ a\ Log[z*w]\ pues\ pueden\ diferenciarse\ en\ un\ 
          m\[UAcute]ltiplo\ entero\ de\ 2  \[Pi]I*) \), 
    \(ComplexExpand[Log[\((\(-1\) + I\ \@3)\) \((\(-\@3\) + I)\)]]\)}], 
  "Input"],

Cell["\<\
Consideremos a continuaci\[OAcute]n las potencias de base y exponente \
complejos.\
\>", "Text"],

Cell[BoxData[
    \(ComplexExpand[\((a\  + \ I\ b)\)^\((c\  + \ I\ d)\)]\)], "Input"],

Cell["\<\
Parece demasiado complicado. Recordemos la definici\[OAcute]n del valor \
principal de la potencia (a + I b)^(c + I d)=Exp[(c + I d)Log[a + I b]].\
\>", "Text"],

Cell[BoxData[
    \(ComplexExpand[Exp[\((c\  + \ I\ d)\) Log[a\  + \ I\ b]]]\)], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula el",
  StyleBox[" valor principal",
    FontSlant->"Italic"],
  " de la potencia."
}], "Text"],

Cell[BoxData[{
    \(ComplexExpand[\((\((\(-I\))\)*\((\(-I\))\))\)^I]\ \  (*\ 
      en\ general\ no\ es\ cierto\ que\ \((u*v)\)\^z\ sea\ igual\ a\ u\^z*
        v\^z\ *) \), 
    \(ComplexExpand[\((\(-I\))\)^I\ *\((\(-\ I\))\)^I]\), 
    \(Clear["\<Global`*\>"]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resoluci\[OAcute]n de ecuaciones", "Section"],

Cell[TextData[{
  "Vamos a estudiar la resoluci\[OAcute]n de varios tipos de ecuaciones que \
por su sencillez conceptual nos han parecido apropiadas como punto de \
partida, pero cuya dificultad num\[EAcute]rica pone de manifiesto la utilidad \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para realizar c\[AAcute]lculos laboriosos y facilitar as\[IAcute] la \
resoluci\[OAcute]n de muchos problemas.\nRecuerda que en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el s\[IAcute]mbolo de igualdad  \"='' es la forma usual de escribir el \
comando \"Set[ ]\" (l\[EAcute]ase ",
  StyleBox["atribuye",
    FontSlant->"Italic"],
  " o ",
  StyleBox["asigna",
    FontSlant->"Italic"],
  "). As\[IAcute] \"expr1=expr2\" y \"Set[expr1,expr2]\" son dos formas de \
decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  que eval\[UAcute]e inmediatamente expr2 y el resultado de esta operaci\
\[OAcute]n lo asigne en adelante al s\[IAcute]mbolo expr1. Se comprende as\
\[IAcute] que \"='' no pueda usarse en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para representar ecuaciones. F\[IAcute]jate en que resolver una ecuaci\
\[OAcute]n, por ejemplo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(x\^4\),
              "TraditionalForm"], "-", \(3  x\^2\), "+", "7"}], "=", "0"}], 
        TraditionalForm]]],
  ", consiste realmente en ",
  StyleBox["comprobar",
    FontSlant->"Italic"],
  " una igualdad; es decir, se trata de obtener los valores de la variable (o \
de las variables) que hacen que dicha igualdad sea ",
  StyleBox["verdadera",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un operador, \"Equal[ ]\", que sirve para ",
  StyleBox["comprobar",
    FontSlant->"Italic"],
  " igualdades. Su sintaxis es \"Equal[expr1,expr2]\" que suele escribirse en \
la forma m\[AAcute]s corta \"expr1==expr2\" y lo que hace es evaluar ambas \
expresiones devolviendo el valor True si la igualdad es verdadera y False en \
otro caso. Pues bien, una ecuaci\[OAcute]n en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se representa, precisamente, en la forma \"expr1==expr2\" donde al menos \
una de las expresiones expr1 o expr2 es simb\[OAcute]lica, es decir contiene \
s\[IAcute]mbolos (variables) a los que no se han asignado anteriormente \
valores. Es claro que en tal caso la igualdad no puede comprobarse por lo que \
\"expr1==expr2\" da tambi\[EAcute]n como salida \"expr1==expr2\". A \
continuaci\[OAcute]n veremos algunas de las muchas funciones de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con ecuaciones y resolverlas."
}], "Text"],

Cell[CellGroupData[{

Cell["Resoluci\[OAcute]n de ecuaciones en una variable", "Subsubsection"],

Cell["Los comandos Solve[ ] , NSolve[ ] y Reduce[ ]", "Theorem"],

Cell[TextData[{
  " La orden \"Solve[ecuaci\[OAcute]n,var]\", intenta resolver \"ecuaci\
\[OAcute]n\" en la variable \"var\". Por ejemplo, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce las f\[OAcute]rmulas algebraicas para las soluciones \
simb\[OAcute]licas exactas de ecuaciones polin\[OAcute]micas en una variable \
de grado menor que cinco."
}], "Text"],

Cell[BoxData[
    \(\(Solve[a*x^2 + b*x + c == 0, x] (*\ 
      soluciones\ de\ la\ ecuaci\[OAcute]n\ de\ segundo\ grado\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Solve[x^3 + a*x^2 + b*x + c == 0, x] (*\ 
      soluciones\ de\ la\ ecuaci\[OAcute]n\ de\ tercer\ grado\ *) \)\)], 
  "Input"],

Cell[TextData[{
  "Mejor que no le pidas a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las soluciones de la ecuaci\[OAcute]n de cuarto grado: son ",
  StyleBox["demasiado",
    FontSlant->"Italic"],
  " complicadas. Es importante que observes que  la salida de \"Solve",
  "[ ]",
  "\" es una ",
  StyleBox["lista",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " cuyos elementos son ",
  StyleBox["listas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  StyleBox["reglas de sustituci\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", cada una de las cuales representa  una soluci\[OAcute]n. Si quieres \
obtener una ",
  StyleBox["lista",
    FontSlant->"Italic"],
  " con las ",
  StyleBox["soluciones",
    FontSlant->"Italic"],
  " de la ecuaci\[OAcute]n puedes conseguirlo con el operador de sustituci\
\[OAcute]n ",
  StyleBox["/.",
    FontWeight->"Bold"],
  " que ya conoces."
}], "Text"],

Cell[BoxData[{
    \(sol = Solve[6  x^3 + 5  x^2 - 2  x - 1 == 0, x]\), 
    \(x /. sol\)}], "Input"],

Cell["\<\
La forma que tiene la salida de \"Solve[ ]\"  permite sustituir \
f\[AAcute]cilmente en una funci\[OAcute]n las soluciones de una ecuaci\
\[OAcute]n. \
\>", "Text"],

Cell[BoxData[{
    \(f[x_] := x^2\), 
    \(sol = Solve[6 - 35\ x + 21\ x\^2 + 20\ x\^3 == 0, x]\), 
    \(f[x] /. sol\  (*
      evaluamos\ la\ funci\[OAcute]n\ en\ las\ soluciones\ de\ la\ 
          ecuaci\[OAcute]n\  - \ 
        tambi\[EAcute]n\ funciona\ con\ f[x /. sol]\  - *) \)}], "Input"],

Cell["\<\
El comando \"Solve[ ]\" repite cada ra\[IAcute]z tantas veces como su \
orden.\
\>", "Text"],

Cell[BoxData[
    \(\(Solve[\(-1\) + x + 2\ x\^2 - 3\ x\^3 + x\^4 == 0] (*\ 
      x = 1\ es\ ra\[IAcute]z\ de\ orden\ 2\ *) \)\)], "Input"],

Cell["\<\
El comando \"Solve[ ]\" no es infalible y puede ocurrir, por ejemplo cuando \
en una ecuaci\[OAcute]n intervienen radicales, que proporcione alguna soluci\
\[OAcute]n falsa. \
\>", "Text"],

Cell[TextData[{
  "Como hemos visto al principio, en ecuaciones que contienen \
par\[AAcute]metros el comando \"Solve[ ]\" trata de encontrara las soluciones \
sin tener en cuenta los posibles valores de los par\[AAcute]metros. El \
comando \"",
  StyleBox["Reduce[ecuaci\[OAcute]n,", "MR"],
  " ",
  StyleBox["var", "TI"],
  StyleBox["]\"", "MR"],
  " simplifica \"",
  StyleBox[
  "ecuaci\[OAcute]n\" y trata de resolverla respecto a la variable \"var\"", 
    "TI"],
  ". Observa la diferenca con \"Solve\"."
}], "Text"],

Cell[BoxData[
    \(Reduce[a\ x^2 + \ b\ x\  + \ c\  == 0, x]\)], "Input"],

Cell[TextData[{
  "Como puedes ver \"Reduce[ ]\" transforma la ecuaci\[OAcute]n inicial en un \
conjunto de ecuaciones m\[AAcute]s simples equivalentes a ella; dichas \
ecuaciones vendr\[AAcute]n expresadas usando operadores l\[OAcute]gicos (&& , \
",
  StyleBox["| |",
    FontWeight->"Bold"],
  ", \[NotEqual]). Adem\[AAcute]s, si la ecuaci\[OAcute]n tiene \
par\[AAcute]metros, \"Reduce[ ]\" presenta los distintos casos que pueden \
darse seg\[UAcute]n los valores de los par\[AAcute]metros. Puedes lograr que \
la salida de este comando sea una ",
  StyleBox["lista",
    FontSlant->"Italic"],
  " de ",
  StyleBox["listas",
    FontSlant->"Italic"],
  " de reglas de sustituci\[OAcute]n usando el comando \"ToRules[ ]\"."
}], "Text"],

Cell[BoxData[
    \(List[ToRules[%]]\)], "Input"],

Cell[TextData[{
  "Y, ya puestos, \[DownQuestion]qu\[EAcute] pasa con las ecuaciones polin\
\[OAcute]micas de grado mayor o igual que cinco? Bueno, como seguramente \
sabes, Evariste Galois (1811-1832) demostr\[OAcute] que no pueden, en \
general, resolverse  por radicales; es decir, que es matem\[AAcute]ticamente \
imposible encontrar f\[OAcute]rmulas expl\[IAcute]citas para sus soluciones. \
Por ello, no te extra\[NTilde]es de que con frecuencia ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no pueda resolverlas de forma exacta."
}], "Text"],

Cell[BoxData[{
    \(Solve[70 + 66  x + 29  x^2 - 39  x^3 - 34  x^4 + 3  x^5 + x^6 == 0, x]
      \), 
    \(Solve[
      3 + 3  x - 7  x^2 - x^3 + 2  x^4 + 3  x^\ 7 - 3  x^\ 8 - x^9 + x^10 == 
        0, x]\)}], "Input"],

Cell[TextData[{
  "En el primer caso hemos tenido suerte: \"Solve[ ]\" ha sido capaz de \
encontrar todas las soluciones de la ecuaci\[OAcute]n (observa que dos de \
ellas son complejas). En el segundo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ha podido encontrar todas las ra\[IAcute]ces de un polinomio tan \
complicado. Ha encontrado tres ra\[IAcute]ces exactas 1, -",
  Cell[BoxData[
      \(TraditionalForm\`\@3\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\@3\)]],
  "; y nos dice que las restantes siete son las ra\[IAcute]ces del polinomio \
",
  Cell[BoxData[
      \(TraditionalForm\`1 + 2  x + x\^7\)]],
  ".\nEn los casos en que \"Solve",
  "[ ]",
  "\" no puede dar soluciones exactas, podemos conseguir soluciones num\
\[EAcute]ricas aproximadas con el comando \"NSolve[ecuaci\[OAcute]n,var]\"."
}], "Text"],

Cell[BoxData[
    \(NSolve[
      3 + 3  x + 7  x^2 + x^3 - 2  x^4 + 3  x^\ 7 - 3  x^\ 8 + x^9 - x^11 == 
        0, x]\)], "Input"],

Cell["\<\
Observa que hay varias soluciones complejas. Puedes obtener una lista con los \
valores num\[EAcute]ricos de las soluciones reales como sigue.\
\>", "Text"],

Cell[BoxData[
    \(reales[x_] := Im[x] == 0; \nSelect[x /. %, reales]\)], "Input"],

Cell["\<\
Usamos \"NSolve[ecuaci\[OAcute]n,var,n]\" si queremos las soluciones con n d\
\[IAcute]gitos de precisi\[OAcute]n. Haz la prueba en el ejemplo anterior con \
n=30.\
\>", "Text"],

Cell["\<\
Hasta ahora hemos considerado ecuaciones polin\[OAcute]micas pero \
\"Solve[ecuaci\[OAcute]n,var]\" tambi\[EAcute]n puede resolver otros tipos de \
ecuaciones. Por ejemplo, teniendo en cuenta que \"var\" puede ser cualquier s\
\[IAcute]mbolo que aparezca en \"ecuaci\[OAcute]n\", podemos resolver \
respecto de \"var=f[x]\" ecuaciones de la forma \"p[f[x]]==0\", donde \"p\" \
es una funci\[OAcute]n polin\[OAcute]mica.\
\>", "Text"],

Cell[BoxData[
    \(Solve[3 - 15  Log[x] + 7  Log[x]^2 == 0, Log[x]]\)], "Input"],

Cell["\<\
A veces \"Solve[ ]\" puede resolver ecuaciones en las que intervienen \
funciones trascendentes (trigonom\[EAcute]tricas y sus inversas, logaritmos, \
exponenciales).\
\>", "Text"],

Cell[BoxData[
    \(x /. Solve[ArcCos[x] - ArcTan[x] == 0, x]\)], "Input"],

Cell[BoxData[
    \(Simplify[TrigToExp[%]]\)], "Input"],

Cell[BoxData[
    \(Solve[Log[x + \((a + x^2)\)^\ \((1/2)\)] == b, x]\)], "Input"],

Cell[TextData[{
  "Pero lo m\[AAcute]s frecuente es que dichas ecuaciones no puedan ser \
resueltas exactamente en forma simb\[OAcute]lica o que no puedan obtenerse \
todas las soluciones posibles de la ecuaci\[OAcute]n. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " suele dar en estos casos mensajes de advertencia. Por ejemplo, cuando al \
resolver una ecuaci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " utiliza alguna funci\[OAcute]n inversa, lo indica con un mensaje en el \
que tambi\[EAcute]n advierte de que puede haber m\[AAcute]s soluciones."
}], "Text"],

Cell[BoxData[
    \(Solve[Sin[x] == 1/2, x]\)], "Input"],

Cell["El comando FindRoot[ ]", "Theorem"],

Cell["\<\
Puede ocurrir que una ecuaci\[OAcute]n no pueda resolverse con ninguno de los \
comandos que hemos visto hasta ahora.\
\>", "Text"],

Cell[BoxData[
    \(NSolve[Cos[x]\  == \ x, x]\)], "Input"],

Cell["\<\
En estos casos podemos todav\[IAcute]a encontrar una soluci\[OAcute]n num\
\[EAcute]rica aproximada usando el comando \
\"FindRoot[funci\[OAcute]n,{var,valor inicial}]\" el cual utiliza el m\
\[EAcute]todo de Newton-Raphson para obtener un cero de \"funci\[OAcute]n\" \
partiendo del \"valor inicial\" de la variable \"var\". Este comando tambi\
\[EAcute]n admite la sintaxis \"FindRoot[ecuaci\[OAcute]n,{var,valorinicial}]\
\".\
\>", "Text"],

Cell[BoxData[{
    \(FindRoot[Cos[x]\  == x, {x, 1}]\), 
    \(FindRoot[Cos[x] - x, {x, 1}]\)}], "Input"],

Cell["\<\
El valor inicial debe ser un punto que est\[EAcute] \"pr\[OAcute]ximo\" de la \
soluci\[OAcute]n que queremos calcular. \
\>", "Text"],

Cell[BoxData[
    \(\(FindRoot[Cos[x] == 1, {x, 4}] (*\ 
      La\ soluci\[OAcute]n\ que\ proporciona\ no\ es\ 0\ sino\ 2  \[Pi]\ *) 
      \)\)], "Input"],

Cell[BoxData[
    \(FindRoot[x*Exp[\(-x\)] == 0, {x, 2}]\)], "Input"],

Cell[TextData[{
  "La soluci\[OAcute]n obtenida en el \[UAcute]ltimo ejemplo no es correcta. \
Eso es debido a que hemos arrancado de un valor inicial demasiado lejos del \
valor de la soluci\[OAcute]n y tambi\[EAcute]n a que la funci\[OAcute]n \"",
  Cell[BoxData[
      \(TraditionalForm\`x\ Exp[\(-x\)]\)]],
  "\" es muy plana, es decir, se apr\[OAcute]xima muy r\[AAcute]pidamente a \
cero cuando la variable aumenta, por eso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede interpretar valores grandes de la variable como ceros de la funci\
\[OAcute]n y eso es lo que ha hecho en este caso. Podemos aumentar la precisi\
\[OAcute]n de \"FindRoot[ ]\" con las opciones \"WorkingPrecision\", \
\"AccuracyGoal\" y \"MaxIterations\".\n \"WorkingPrecision\" es una opci\
\[OAcute]n que indica cu\[AAcute]ntos d\[IAcute]gitos deben mantenerse en los \
c\[AAcute]lculos internos. Por defecto es igual a \"MachinePrecision\" (16 en \
la mayor\[IAcute]a de los ordenadores).\n \"AccuracyGoal\" especifica el n\
\[UAcute]mero de d\[IAcute]gitos a la derecha del punto decimal que deben \
tenerse en cuenta al evaluar la funci\[OAcute]n en una posible \
soluci\[OAcute]n. Por defecto es igual a \"WorkingPrecision\"-10.\n \
\"MaxIterations\" especifica el m\[AAcute]ximo de iteraciones a realizar \
antes de encontrar la soluci\[OAcute]n teniendo en cuenta el valor actual de \
\"AccuracyGoal\". Por defecto es igual a 15."
}], "Text"],

Cell["\<\
El siguiente ejemplo proporciona, debido a que la funci\[OAcute]n es muy \
plana, un resultado muy poco exacto.\
\>", "Text"],

Cell[BoxData[
    \(\(FindRoot[\((x - 2)\)^4  Exp[\(-x^2\)], {x, 1}] (*\ 
      Calcula\ la\ soluci\[OAcute]n\ con\ muy\ poca\ exactitud\ *) \)\)], 
  "Input"],

Cell["\<\
Tratamos de mejorarlo aumentando el n\[UAcute]mero de d\[IAcute]gitos con que \
se realizan los c\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[
    \(\(FindRoot[\((x - 2)\)^4  Exp[\(-x^2\)], {x, 1}, 
      WorkingPrecision -> 32] (*\ 
      Haciendo\ WorkingPrecision = 
        \(32\ hacemos\ tambi\[EAcute]n\ AccuracyGoal = 22\)\ *) \)\)], "Input"],

Cell[TextData[{
  "Casi no lo hemos mejorado y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nos dice que 15 iteraciones son insuficientes para obtener una soluci\
\[OAcute]n con \"AccuracyGoal=22\". Debemos hacer m\[AAcute]s iteraciones."
}], "Text"],

Cell[BoxData[
    \(\(FindRoot[\((x - 2)\)^4  Exp[\(-x^2\)], {x, 1}, 
      WorkingPrecision -> 32, MaxIterations -> 50]\n (*\ 
      Observa\ que\ la\ soluci\[OAcute]n\ se\ presenta\ con\ 32\ 
        d\[IAcute]gitos\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(\((x - 2)\)^4\ Exp[\(-x^2\)] /. %\  (*\ 
      Evaluando\ la\ funci\[OAcute]n\ en\ la\ soluci\[OAcute]n\ obtenida\ 
          comprobamos\ que\ obtenemos\ un\ n\[UAcute]mero\ con\ 
          AccuracyGoal = 22\ ceros\ a\ la\ derecha\ del\ punto\ decimal\ *) 
      \)\)], "Input"],

Cell["\<\
Para elegir los valores iniciales  suele ser de gran utilidad una \
representaci\[OAcute]n gr\[AAcute]fica. Podemos selecionar un gr\[AAcute]fico \
con el rat\[OAcute]n y pulsando la tecla \"Control\" el puntero se convierte \
en una cruz, y en la parte inferior izquierda de la pantalla vemos las \
coordenadas de los puntos sobre los que nos desplazamos. Puedes hacer clic en \
un punto y copiar las coordenadas del mismo con control+C y puedes pegarlas \
con control+V.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Plot[Exp[\(-x\)] - x^2 + 1, {x, 1, 2}]; 
    \) (*\ En\ este\ intervalo\ la\ funci\[OAcute]n\ cambia\ de\ signo\ *) 
      \)\)], "Input"],

Cell[BoxData[
    \(\(FindRoot[Exp[\(-x\)] - x^2 + 1, {x, 1.2}] (*\ 
      Sobre\ la\ gr\[AAcute]fica\ se\ ve\ que\ el\ valor\ de\ la\ ra\[IAcute]z
        \ est\[AAcute]\ pr\[OAcute]ximo\ a\ 1.2\ *) \n (*\ 
      NSolve\ no\ calcula\ las\ soluciones\ de\ Exp[\(-x\)] - x^2 + 1 == 0
        \ *) \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resoluci\[OAcute]n de sistemas de ecuaciones en varias variables", 
  "Subsubsection"],

Cell["\<\
Los comandos vistos pueden usarse tambi\[EAcute]n para calcular las \
soluciones de sistemas de ecuaciones en varias variables. Lo \[UAcute]nico \
que hay que hacer es sustituir en cada caso \"ecuaci\[OAcute]n\" por una \
lista de ecuaciones \"{ecuac1,ecuac2,...}\" y especificar tambi\[EAcute]n en \
una lista las variables respecto de las que queremos resolver el sistema \
\"{var1,var2,...}\". Al igual que antes, \"Solve[ ]\" y \"NSolve[ ]\" sirven \
principalmente para resolver sistemas de ecuaciones polin\[OAcute]micas. El \
primero s\[OAcute]lo resuelve sistemas de grado bajo pero con soluciones \
exactas, expresadas mediante radicales. El segundo da soluciones aproximadas \
pero sirve para cualquier grado. Como puedes suponer, el comando \"Reduce[ \
]\" cuando se aplica a sistemas de ecuaciones que contienen \
par\[AAcute]metros realiza una discusi\[OAcute]n de las soluciones del \
sistema seg\[UAcute]n los posibles valores de los par\[AAcute]metros. Este \
comando es particularmente \[UAcute]til para sistemas de ecuaciones lineales \
con par\[AAcute]metros.\
\>", "Text"],

Cell[BoxData[
    \(\(Solve[{x^2 + y^2 == 1, \((x - 2)\)^2 + \((y - 2)\)^2 == 4}, {x, y}]
      \  (*\ Calculamos\ los\ puntos\ de\ intersecci\[OAcute]n\ de\ dos\ 
        circunferencias\ *) \)\)], "Input"],

Cell["\<\
Cuando hay m\[AAcute]s variables que ecuaciones algunas variables son \
tratadas como par\[AAcute]metros.\
\>", "Text"],

Cell[BoxData[
    \(\(sol = Solve[{x^2 + y^2 + z^2 == 1, x + y + z == 0}, {y, z}]\ \)\)], 
  "Input"],

Cell[TextData[{
  "Hemos obtenido de esta forma las ecuaciones param\[EAcute]tricas de la \
circunferencia intersecci\[OAcute]n de la esfera ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(x\^2\),
                  "TraditionalForm"], "+", \(y\^2\)}],
              "TraditionalForm"], "+", \(z\^2\)}], "=", "1"}], 
        TraditionalForm]]],
  " y el plano ",
  Cell[BoxData[
      \(TraditionalForm\`x + y + z = 0\)]],
  "."
}], "Text"],

Cell["\<\
Naturalmente, podemos usar \"Solve[ ]\" para resolver sistemas de ecuaciones \
lineales.\
\>", "Text"],

Cell[BoxData[
    \(\(Solve[{x + y + z == 2, x - 2\ y + z == \(-1\), 
        x + 3\ y - 2\ z == 4}, {x, y, z}] (*\ 
      Este\ sistema\ tiene\ soluci\[OAcute]n\ 
        \(\[UAcute]nica : \ 3\ planos\ que\ se\ cortan\ en\ un\ punto\)\ *) 
      \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Solve[{x + y + z == 2, x - 2\ y + z == \(-1\), 
        x - y\/2 + z == 1\/2}, {x, y, z}]\  (*\ 
      Dos\ planos\ que\ se\ cortan\ en\ una\ recta\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "El sistema anterior no tiene soluci\[OAcute]n \[UAcute]nica y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " te informa de ello. Cuando no hay soluciones la salida de \"Solve[ ]\" es \
una lista vac\[IAcute]a \"{ }\"."
}], "Text"],

Cell[BoxData[
    \(\(Solve[{x + y + z == 2, x + y + z == 0, x + 3\ y - 2\ z == 4}, {x, y, 
        z}]\  (*\ Tres\ planos\ paralelos\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell["Y la salida es \"{{}}\" si cualquier valor es soluci\[OAcute]n.", "Text"],

Cell[BoxData[
    \(Solve[x^2 + x == x \((x + 1)\), x]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "\tDiscute el sistema de ecuaciones ",
  Cell[BoxData[
      \(TraditionalForm\`x + a*y + z = 1, \ 3  x - 2  y + z = b, \ 
      x + y - z = 1\)]],
  " en funci\[OAcute]n de los par\[AAcute]metros ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\ \)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula los puntos del plano donde se cortan las par\[AAcute]bolas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(y = 2  x\^2\),
            "TraditionalForm"], "+", \(a\ x\), " ", "+", " ", "b"}], 
        TraditionalForm]]],
  ". Considera todos los casos posibles dependiendo de los valores de ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". Haz una representaci\[OAcute]n gr\[AAcute]fica para cada caso."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula las soluciones de   ",
  Cell[BoxData[
      \(TraditionalForm\`8 \( sen(x)\) + 1 - x\^2/3 = 0\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Calcula la soluci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`tan(x) = 1/x\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(]\) \(0\)\), \[Pi]/\(\(2\)\([\)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula una soluci\[OAcute]n cerca de (0,0) del siguiente sistema de \
ecuaciones  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(\(sen(x)\)\ \(cos(y)\)\  = 1/4\)},
              {\(x\ y = 1\)}
              }]}], TraditionalForm]]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Partiendo del valor inicial 0.02, usa \"FindRoot[ ]\" para calcular una ra\
\[IAcute]z de ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\(f(x)\), "=", 
            FormBox[\(\(x\^2\) \(Exp(\(-1\)/x\^2)\)\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "  por la condici\[OAcute]n de que el valor de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en dicha ra\[IAcute]z sea del orden de ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-17\)\)]],
  ". Usa para ello las opciones de \"FindRoot[ ]\" que creas oportunas. \
\[DownQuestion]Cu\[AAcute]ntas iteraciones son necesarias?"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Calcula las soluciones del sistema de ecuaciones lineales  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(x + y = \(-1\)\)},
              {\(10  x + \((55/10 - \ t)\) y = 0\)}
              }]}], TraditionalForm]]],
  "   para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`t = \(-10\), \(-9\),  ... , 9, 10\)]],
  ".\nSugerencia. Puedes usar Table[Solve[ ], {i,-10,10}].\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Haz una representaci\[OAcute]n gr\[AAcute]fica de la soluci\[OAcute]n del \
sistema de ecuaciones lineales  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(x + 3  y = \(-1\)\)},
              {\(x\  - y = 1\)}
              }]}], TraditionalForm]]],
  "  En dicha representaci\[OAcute]n deben aparecer las dos rectas \
representadas por las ecuaciones y su punto de intersecci\[OAcute]n en rojo \
con tama\[NTilde]o apropiado.\n",
  StyleBox[" c) ",
    FontWeight->"Bold"],
  "Aprovecha el trabajo hecho en",
  StyleBox[" b) ",
    FontWeight->"Bold"],
  "para hacer una animaci\[OAcute]n para ver la variaci\[OAcute]n de la \
soluci\[OAcute]n obtenida en el apartado ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " en funci\[OAcute]n de la variaci\[OAcute]n del par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". "
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Resoluci\[OAcute]n de ecuaciones."], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Resoluci\[OAcute]n de ecuaciones."], "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 76, 0, 69, "Title"],
Cell[1788, 51, 203, 3, 72, "Author"],

Cell[CellGroupData[{
Cell[2016, 58, 39, 0, 69, "Section"],
Cell[2058, 60, 231, 6, 99, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2326, 71, 111, 3, 69, "Section"],
Cell[2440, 76, 480, 10, 54, "Text"],
Cell[2923, 88, 343, 13, 186, "Input"],
Cell[3269, 103, 225, 5, 33, "Text"],
Cell[3497, 110, 506, 12, 75, "Text"],
Cell[4006, 124, 131, 3, 102, "Input"],
Cell[4140, 129, 773, 27, 57, "Text"],
Cell[4916, 158, 378, 13, 102, "Input"],
Cell[5297, 173, 221, 3, 54, "Text"],
Cell[5521, 178, 146, 2, 60, "Input"],
Cell[5670, 182, 874, 18, 97, "Text"],
Cell[6547, 202, 72, 1, 60, "Input"],
Cell[6622, 205, 1583, 53, 126, "Text"],
Cell[8208, 260, 76, 2, 91, "Input"],
Cell[8287, 264, 156, 3, 67, "Input"],
Cell[8446, 269, 552, 10, 89, "Input"],
Cell[9001, 281, 207, 4, 88, "Input"],
Cell[9211, 287, 180, 6, 33, "Text"],
Cell[9394, 295, 148, 5, 33, "Text"],
Cell[9545, 302, 65, 1, 60, "Input"],
Cell[9613, 305, 262, 7, 33, "Text"],
Cell[9878, 314, 214, 4, 102, "Input"],
Cell[10095, 320, 47, 0, 33, "Text"],
Cell[10145, 322, 70, 1, 60, "Input"],
Cell[10218, 325, 354, 6, 112, "Input"],
Cell[10575, 333, 106, 3, 33, "Text"],
Cell[10684, 338, 85, 1, 60, "Input"],
Cell[10772, 341, 170, 3, 33, "Text"],
Cell[10945, 346, 89, 1, 60, "Input"],
Cell[11037, 349, 203, 8, 33, "Text"],
Cell[11243, 359, 276, 5, 102, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11556, 369, 51, 0, 69, "Section"],
Cell[11610, 371, 2737, 64, 309, "Text"],

Cell[CellGroupData[{
Cell[14372, 439, 73, 0, 46, "Subsubsection"],
Cell[14448, 441, 64, 0, 60, "Theorem"],
Cell[14515, 443, 377, 8, 54, "Text"],
Cell[14895, 453, 143, 3, 60, "Input"],
Cell[15041, 458, 148, 3, 60, "Input"],
Cell[15192, 463, 949, 33, 77, "Text"],
Cell[16144, 498, 101, 2, 81, "Input"],
Cell[16248, 502, 174, 4, 33, "Text"],
Cell[16425, 508, 299, 6, 124, "Input"],
Cell[16727, 516, 102, 3, 33, "Text"],
Cell[16832, 521, 140, 2, 60, "Input"],
Cell[16975, 525, 198, 4, 33, "Text"],
Cell[17176, 531, 523, 14, 75, "Text"],
Cell[17702, 547, 74, 1, 60, "Input"],
Cell[17779, 550, 739, 17, 76, "Text"],
Cell[18521, 569, 49, 1, 60, "Input"],
Cell[18573, 572, 561, 10, 75, "Text"],
Cell[19137, 584, 221, 5, 81, "Input"],
Cell[19361, 591, 851, 21, 109, "Text"],
Cell[20215, 614, 132, 3, 60, "Input"],
Cell[20350, 619, 166, 3, 33, "Text"],
Cell[20519, 624, 83, 1, 81, "Input"],
Cell[20605, 627, 187, 4, 33, "Text"],
Cell[20795, 633, 443, 7, 75, "Text"],
Cell[21241, 642, 81, 1, 60, "Input"],
Cell[21325, 645, 190, 4, 33, "Text"],
Cell[21518, 651, 74, 1, 60, "Input"],
Cell[21595, 654, 55, 1, 60, "Input"],
Cell[21653, 657, 82, 1, 60, "Input"],
Cell[21738, 660, 601, 12, 75, "Text"],
Cell[22342, 674, 56, 1, 60, "Input"],
Cell[22401, 677, 41, 0, 60, "Theorem"],
Cell[22445, 679, 141, 3, 33, "Text"],
Cell[22589, 684, 59, 1, 60, "Input"],
Cell[22651, 687, 452, 8, 75, "Text"],
Cell[23106, 697, 105, 2, 81, "Input"],
Cell[23214, 701, 144, 3, 33, "Text"],
Cell[23361, 706, 155, 3, 60, "Input"],
Cell[23519, 711, 69, 1, 60, "Input"],
Cell[23591, 714, 1444, 23, 258, "Text"],
Cell[25038, 739, 135, 3, 33, "Text"],
Cell[25176, 744, 159, 3, 60, "Input"],
Cell[25338, 749, 137, 3, 33, "Text"],
Cell[25478, 754, 220, 4, 81, "Input"],
Cell[25701, 760, 264, 6, 54, "Text"],
Cell[25968, 768, 237, 4, 81, "Input"],
Cell[26208, 774, 301, 5, 102, "Input"],
Cell[26512, 781, 496, 8, 75, "Text"],
Cell[27011, 791, 162, 3, 60, "Input"],
Cell[27176, 796, 311, 5, 102, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27524, 806, 92, 1, 46, "Subsubsection"],
Cell[27619, 809, 1102, 16, 159, "Text"],
Cell[28724, 827, 207, 3, 81, "Input"],
Cell[28934, 832, 129, 3, 33, "Text"],
Cell[29066, 837, 101, 2, 60, "Input"],
Cell[29170, 841, 531, 17, 33, "Text"],
Cell[29704, 860, 112, 3, 33, "Text"],
Cell[29819, 865, 288, 6, 81, "Input"],
Cell[30110, 873, 215, 4, 95, "Input"],
Cell[30328, 879, 261, 6, 33, "Text"],
Cell[30592, 887, 179, 3, 60, "Input"],
Cell[30774, 892, 79, 0, 33, "Text"],
Cell[30856, 894, 67, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30960, 900, 31, 0, 48, "Exercise"],
Cell[30994, 902, 345, 12, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31376, 919, 31, 0, 48, "Exercise"],
Cell[31410, 921, 587, 18, 54, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32034, 944, 31, 0, 48, "Exercise"],
Cell[32068, 946, 152, 5, 33, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32257, 956, 31, 0, 48, "Exercise"],
Cell[32291, 958, 244, 8, 33, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32572, 971, 31, 0, 48, "Exercise"],
Cell[32606, 973, 313, 10, 47, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32956, 988, 31, 0, 48, "Exercise"],
Cell[32990, 990, 663, 17, 54, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33690, 1012, 31, 0, 48, "Exercise"],
Cell[33724, 1014, 1416, 40, 186, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

